# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import format_valid, request_valid, generate_password, interface_response, \
    MESSAGE_CODE, SUCCESS_CODE, FORCED_OFFLINE, save_log
from django.utils.translation import ugettext_lazy as _
import json


response_defined = {
    0: {
        'response': 0,
        'error': 'login successful',
        'describe': 'login successful'
    },
    -10001: {
        'response': -10001,
        'error': 'login failed',
        'describe': 'username or password is wrong'
    },
    -10002: {
        'response': -10001,
        'error': 'login failed',
        'describe': 'exception'
    },
    -10003: {
        'response': -10003,
        'error': 'login failed',
        'describe': 'request params can not find username'
    },
}


class BioTimeAppLogin(object):

    """
    【Login】登录接口
    """
    @ladonize(str, str, str, int, str, rtype=str)
    def login(self, username, password, client, source, device_token):
        """
        APP登录
        @param username:        用户名(工号)
        @param password:        密码
        @param client:          手机ID，手机唯一标识符
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @rtype: 返回执行结果
            请求成功：
                {code": "1", "data": {"token": "088d29bfba7bf97090bdf2c171648553", "role": 账户角色, "copyright": "版权声明", "pin": "工号"}, "error"："", "describe": "", "message": "" }
                role: 1: Employee(员工), 2: Administrator(管理员)， 3: Approver(审批人)
            请求失败
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.personnel.models.model_emp import Employee, format_pin, device_pin
        from mysite.iclock.models.model_applist import AppList
        from base.middleware.threadlocals import get_current_request
        from mysite.personnel.models.model_dept_approver import DepartmentApprover
        from django.db.models import Q
        import datetime
        import time
        import os
        import hashlib
        print "[*]Login---. Username:{0}, Password:{1}, Client:{2}".format(username, password, client)
        print "[*]Source:{0}, Device Token:{1}".format(source, device_token)
        req = get_current_request()
        username = username.strip()
        password = password.strip()
        client = client.strip()
        if not client:
            error = 'login failed'
            describe = 'param client missing'
            message = 'Illegal request'
            save_log(req, 'Login', client, json.dumps((username, password, client)), describe, status=0)
            return interface_response(MESSAGE_CODE, '', error, describe, message)
        if username:
            try:
                pin = format_pin(username)
                emps = Employee.objects.filter(PIN=pin, selfpassword=password, status=0)
                if not emps:
                    error = 'login failed'
                    describe = 'incorrect username or password'
                    message = 'incorrect username or password'
                    save_log(req, 'Login', client, json.dumps((username, password, client)), describe, status=0)
                    return interface_response(MESSAGE_CODE, '', error, describe, message)
                else:
                    emp = emps[0]
                    if not emp.app_status:
                        error = 'account disabled'
                        describe = 'account disabled'
                        message = 'Account disable, please contact admin to enable.'
                        save_log(req, 'Login', client, json.dumps((username, password, client)), describe, status=0)
                        return interface_response(MESSAGE_CODE, '', error, describe, message)
                    now = datetime.datetime.now()
                    key = '{0}{1}{2}'.format(pin, os.getpid(), int(round(time.time() * 1000)))
                    token = hashlib.md5(key.encode('utf-8')).hexdigest()
                    active_apps = AppList.objects.filter(active=True).filter(Q(username=pin) | Q(client_id=client)) #single login
                    if active_apps:
                        active_apps.update(active=False)
                    apps = AppList.objects.filter(username=pin, client_id=client)
                    if apps:
                        app = apps[0]
                        if not app.enable:
                            error = 'Request blocked'
                            describe = 'App client already block by administrator'
                            message = _(u'App client blocked')
                            save_log(req, 'Login', client, json.dumps((username, password, client)), describe, status=0)
                            return interface_response(MESSAGE_CODE, '', error, describe, message)
                    else:
                        app = AppList()
                        app.username = pin
                        app.client_id = client
                    app.active = True
                    app.login_time = now
                    app.last_active = now
                    app.token = token
                    app.client_category = source
                    app.device_token = device_token
                    app.save()
                    zk_copyright_en = 'Copyright 2018. ZKTeco Security LLC. All rights reserved.'
                    zk_copyright_ar = 'حقوق الملكية محفوظة 2017 شركة زد كي تيكو الشرق الأوسط'
                    # save_log(req, 'Login', client, json.dumps((username, password, client)), 'successful')
                    app_role = emp.app_role
                    if app_role in (1, ):
                        approvers = DepartmentApprover.objects.filter(approver=emp)
                        if approvers:
                            app_role = 3
                    response = {
                        'token': token,
                        'role': app_role,
                        'pin': pin,
                        'copyright': zk_copyright_en,
                        'copyright_en': zk_copyright_en,
                        'copyright_ar': zk_copyright_ar
                    }
                    return interface_response(1, json.dumps(response), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                error = 'login failed'
                describe = u'{0}'.format(e)
                message = _(u'System Exception')
                save_log(req, 'Login', client, json.dumps((username, password, client)), describe, status=0)
                return interface_response(MESSAGE_CODE, '', error, describe, message)
        else:
            error = 'login failed'
            describe = 'request params can not find username'
            message = _(u'Params Exception')
            save_log(req, 'Login', client, json.dumps((username, password, client)), describe, status=0)
            return interface_response(MESSAGE_CODE, '', error, describe, message)

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def sign_out(self, source, device_token, language, token):
        """
        注销
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:        语言(en/ar)
        @param token:           token
        @rtype:
            {"code": 1, "error":"", "describe":"", "message":"", "data":""}
        """
        from mysite.iclock.models.model_applist import AppList
        if token:
            apps = AppList.objects.filter(token=token)
            if apps:
                apps.update(active=False)
            message = _(u'Sign out successful')
            return interface_response(SUCCESS_CODE, '', '', 'successful', message)
        else:
            message = _(u'Illegal request')
            return interface_response(FORCED_OFFLINE, '', '', 'Token missing', message)

    @ladonize(str, str, int, str, str, rtype=str)
    def reset_password(self, search_item, source, device_token, language, client):
        """
        密码重置
        @param search_item:     员工工号/邮箱地址
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:        APP语言
        @param client:          手机ID，手机唯一标识符
        @rtype:
            {"code": 1, "error":"", "describe":"", "message":"", "data":""}
        """
        from mysite.iclock.models.model_applist import AppList
        from mysite.personnel.models.model_emp import Employee, format_pin
        from base.email_setting import push_email
        from base.middleware.threadlocals import get_current_request
        req = get_current_request()
        if search_item:
            try:
                search_item = search_item.strip()
                if search_item.find('@') != -1: #eamil
                    emps = Employee.objects.filter(email=search_item)
                else:
                    pin = format_pin(search_item)
                    emps = Employee.objects.filter(PIN=pin)
                if emps:
                    emp = emps[0]
                    pin = emp.PIN
                    apps = AppList.objects.filter(username=pin, client_id=client, enable=True)
                    if apps:
                        new_password = generate_password(6)
                        email = emp.email
                        emp.selfpassword = new_password
                        emp.save()
                        title = u'BioTime App Password Reset'
                        context = u"""
                        Dear {0} {1},
                            Please find your new password <font color="blue">{2}</font>
                        """.format(emp.PIN, emp.EName, new_password)
                        push_email(title, json.dumps(context), email, email_template='')
                        describe = 'successful'
                        save_log(req, 'reset_password', client, json.dumps((search_item, language, client)), describe)
                        return interface_response(SUCCESS_CODE, '', '', describe)
                    else:
                        error = 'Reset Failed'
                        describe = 'Reset password must to do on the mobile with use'
                        message = _(u'Illegal operation, please contact with administrator')
                        save_log(req, 'reset_password', client, json.dumps((search_item, language, client)), describe, status=0)
                        return interface_response(MESSAGE_CODE, '', error, describe, message)
                else:
                    error = 'reset failed'
                    describe = 'User not exists'
                    message = _(u'User Not Found')
                    save_log(req, 'reset_password', client, json.dumps((search_item, language, client)), describe, status=0)
                    return interface_response(MESSAGE_CODE, '', error, describe, message)
            except Exception, e:
                import traceback
                traceback.print_exc()
                error = 'reset failed'
                describe = u'{0}'.format(e)
                message = _(u'System Exception')
                save_log(req, 'reset_password', client, json.dumps((search_item, language, client)), describe, status=0)
                return interface_response(MESSAGE_CODE, '', error, describe, message)
        else:
            error = ''
            describe = ''
            message = _(u'Please input the available value')
            save_log(req, 'reset_password', client, json.dumps((search_item, language, client)), describe, status=0)
            return interface_response(MESSAGE_CODE, '', error, describe, message)

    @ladonize(str, str, int, str, rtype=str)
    def version_verify(self, version, client, source, device_token):
        """
        @param version:           App Version
        @param client:            手机唯一标识
        @param source:            数据来源(1: IOS， 2：Android)
        @param device_token:      消息推送Token
        @return:
        """
        return interface_response(SUCCESS_CODE, json.dumps({'beta': 1}), '', 'successful')
